;
;								EJEMPLO 12
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;El Display de 7 segmentos. Decodificador hex. BCD a 7 segmentos.
;
;Mediante los cuatro interruptores RA0-RA3 se introduce un valor hexadecimal de 4 bits
;que debe visualizarse sobre el display.
	
		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdig y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

		__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC
                    
				org	0x00			;Vector de RESET
				goto	Inicio
				org	0x05

;**********************************************************************************
;Tabla: Esta rutina convierte el cdigo binario presente en los 4 bits de menos peso
;del reg. W en su equivalente a 7 segmentos. Para ello el valor de W se suma al valor actual
;del PC. Se obtiene un desplazamiento que apunta al elemento deseado de la tabla.El cdigo 7 
;segmentos retorna tambin en el reg. W.

Tabla:		addwf	PCL,F		;Desplazamiento sobre la tabla
			retlw	b'00111111'	;Dgito 0
			retlw	b'00000110'	;Dgito 1
			retlw	b'01011011'	;Dgito 2
			retlw	b'01001111'	;Dgito 3
			retlw	b'01100110'	;Dgito 4
			retlw	b'01101101'	;Dgito 5
			retlw	b'01111101'	;Dgito 6
			retlw	b'00000111'	;Dgito 7
			retlw	b'01111111'	;Dgito 8
			retlw	b'01100111'	;Dgito 9
			retlw	b'01110111'	;Dgito A
			retlw	b'01111100'	;Dgito B
			retlw	b'00111001'	;Dgito C
			retlw	b'01011110'	;Dgito D
			retlw	b'01111001'	;Dgito E
			retlw	b'01110001'	;Dgito F

Inicio	   	clrf 	PORTB		;Borra los latch de salida
			bsf		STATUS,RP0	;Selecciona banco 1
			clrf	TRISB		;Puerta B se configura como salida
			movlw	0x06
			movwf	ADCON1		;Puerta A digital
			movlw	b'00111111'		
			movwf	TRISA		;Puerta A se configura como entrada		
			bcf		STATUS,RP0	;Selecciona banco 0			                                                                         

Loop		movf	PORTA,W
			andlw	b'00001111'	;Lee el cdigo de RA0-RA3
			call	Tabla		;Convierte a 7 segmentos
			movwf	PORTB		;Visualiza sobre el display
			goto 	Loop

			end					;Fin del programa fuente
	
